implementation module showtm

import	StdClass
from	deltaIOSystem	import UpdateArea
import	deltaPicture
import	StdInt
from	StdString		import length, %
from	StdChar			import toString
from	StdBool			import &&, otherwise
import	StdArray
import	tm

StatePos	:== (10,17)
ErrorPos	:== (10,17)
NamePos		:== (130,17)
TapeY		:== 40
Room		:== 14
Offset		:== 10
TransY		:== 40
MaxX		:== 29900

/*	Draw a Turing machine: tape, transitions, name and state.
*/
ShowTape :: !Tape !Picture -> Picture
ShowTape {content,head} pic
	# pic	= EraseRectangle	((0,0),(MaxX,100))				pic
	  pic	= ShowCont			0 (size content) Offset content	pic
	  pic	= DrawTapeFrame										pic
	  pic	= DrawHeadRect		(HeadPos head) RedColour		pic
	= pic
where
	ShowCont :: !Int !Int Int !String !Picture -> Picture
	ShowCont i l x s pic
		| i==l
		= pic
		# pic		= MovePenTo	 (x,TapeY)				pic
		  pic		= DrawString (toString (s.[i]))		pic
		  pic		= ShowCont	 (i+1) l (x+Room) s		pic
		| otherwise	= pic
	
	DrawTapeFrame :: !Picture -> Picture
	DrawTapeFrame pic
		# pic	= MovePenTo (x,   y2)		pic
		  pic	= LinePenTo (MaxX,y2)		pic
		  pic	= MovePenTo (x,   y1)		pic
		  pic	= LinePenTo (MaxX,y1)		pic
		  pic	= DrawCellBorders x y1 y2	pic
		= pic
	where
		x	= Offset-4
		y1	= TapeY -13
		y2	= TapeY +5
		
		DrawCellBorders :: !Int Int Int !Picture -> Picture
		DrawCellBorders x y1 y2 pic
			| x>MaxX
			= pic
			# pic		= MovePenTo			(x,y2)			pic
			  pic		= LinePenTo			(x,y1)			pic
			  pic		= DrawCellBorders	(x+Room) y1 y2	pic
			| otherwise	= pic

ShowTransitions :: ![Transition] !String !Picture -> Picture
ShowTransitions trs state pic
	# pic	= EraseRectangle	((0,0),(MaxX,300))	pic
	  pic	= ShowState			state				pic
	  pic	= ShowTransFrame						pic
	  pic	= DrawTransitions	0 trs				pic
	= pic
where
	ShowState :: !String !Picture -> Picture
	ShowState state pic
		# pic	= DrawRectangle	((x-4,y-11),(x+101,y+4))	pic
		  pic	= MovePenTo		StatePos					pic
		  pic	= DrawString	"State:"					pic
		  pic	= ShowNextState	state						pic
		= pic
	where
		(x,y)	= StatePos
	
	ShowTransFrame :: !Picture -> Picture
	ShowTransFrame pic
		# pic	= DrawRectangle ((Offset-4,y1),(limit,y2+1)) pic
		  pic	= ShowTransBorders (Offset+135) limit y1 y2 pic
		= pic
	where
		limit	= MaxX-80
		y1		= TransY-14
		y2		= TransY+201
		
		ShowTransBorders :: !Int !Int Int Int !Picture -> Picture
		ShowTransBorders x limit y1 y2 pic
			| x>=limit
			= pic
			# pic	= MovePenTo (x,y2) pic
			  pic	= LinePenTo (x,y1) pic
			| otherwise
			= ShowTransBorders (x+140) limit y1 y2 pic
	
	DrawTransitions :: !Int ![Transition] !Picture -> Picture
	DrawTransitions n [transition:transitions] pic
		# pic	= DrawTrans n transition pic
		  pic	= DrawTransitions (n+1) transitions pic
		= pic
	DrawTransitions _ _ pic
		= pic

ShowTransition :: !Int !Int !Picture -> Picture
ShowTransition old new pic
	# pic	= DrawTransRect old WhiteColour pic
	  pic	= DrawTransRect new RedColour pic
	= pic
where
	DrawTransRect :: !Int !Colour !Picture -> Picture
	DrawTransRect nr color pic
		# pic	= SetPenColour	color						pic
		  pic	= DrawRectangle	((x-1,y-11),(x+133,y+4))	pic
		  pic	= SetPenColour	BlackColour					pic
		= pic
	where
		(x,y)	= TransPos nr

DrawTrans :: !Int !Transition !Picture -> Picture
DrawTrans n {start,sigma,end,move} pic
	# pic	= MovePenTo (x+5,y) pic
	  pic	= DrawString (start+++","+++toString sigma+++" -> "+++end+++","+++toString move) pic
	= pic
where
	(x,y)	= TransPos n

ShowTapePart :: !Tape !Int !Int !Picture -> Picture
ShowTapePart {content,head} start end pic
	# pic	= MovePenTo		(x,   y2)											pic
	  pic	= LinePenTo		(MaxX,y2)											pic
	  pic	= MovePenTo		(x,   y1)											pic
	  pic	= LinePenTo		(MaxX,y1)											pic
	  pic	= ShowContPart	0 (size content) Offset content (start-30) (end+30)	pic
	  pic	= DrawHeadRect	(HeadPos head) RedColour							pic
	= pic
where
	x		= Offset-4
	y1		= TapeY -13
	y2		= TapeY +5
	
	ShowContPart :: Int Int !Int String Int !Int !Picture -> Picture
	ShowContPart i l x s f t pic
		| x>t		= pic
		| x<f		= ShowContPart	(i+1) l (x+Room) s f t	pic
		# pic		= MovePenTo		(x-4,TapeY+5)			pic
		  pic		= LinePenTo		(x-4,TapeY-13)			pic
		| i>=l		= ShowContPart	(i+1) l (x+Room) s f t	pic
		# pic		= MovePenTo		(x,TapeY)				pic
		  pic		= DrawString	(toString (s.[i]))		pic
		| otherwise	= ShowContPart	(i+1) l (x+Room) s f t	pic


/*	Make a step of the T.M. (transition) visible on the screen.
*/
ShowNewTape :: !Comm !Int !Picture -> Picture
ShowNewTape com pos pic
	= ShowComm com (HeadPos pos) pic
where
	ShowComm :: !Comm !Int !Picture -> Picture
	ShowComm Erase pos pic
		# pic	= EraseCell		pos pic
		  pic	= MoveToHeadPos	pos	pic
		  pic	= DrawString "#"	pic
		= pic
	ShowComm None pos pic
		= pic
	ShowComm (Write c) pos pic
		# pic	= EraseCell				pos	pic
		  pic	= MoveToHeadPos			pos	pic
		  pic	= DrawString (toString c)	pic
		= pic
	ShowComm MoveR1 pos pic
		# pic	= MovePenTo		(newpos+2,TapeY)	pic
		  pic	= DrawString	"#"					pic
		  pic	= DrawHeadRect	pos    WhiteColour	pic
		  pic	= DrawHeadRect	newpos RedColour	pic
		= pic
	where
		newpos	= pos+Room
	ShowComm MoveR pos pic
		# pic	= DrawHeadRect pos WhiteColour pic
		  pic	= DrawHeadRect newpos RedColour pic
		= pic
	where
		newpos	= pos+Room
	ShowComm MoveL pos pic
		# pic	= DrawHeadRect pos WhiteColour pic
		  pic	= DrawHeadRect newpos RedColour pic
		= pic
	where
		newpos	= pos-Room
	ShowComm Halt pos pic
		= pic
	ShowComm ErrorL pos pic
		= DrawError "Error: Head went over left edge." pic
	ShowComm ErrorT pos pic
		= DrawError "Error: No Transition applicable." pic
	ShowComm x pos pic
		= DrawError "Fatal Error: Unknown Command." pic

ShowNextState :: !String !Picture -> Picture
ShowNextState state pic
	# pic		    = SetPenColour	      RedColour				        pic
      (width,pic)	= PictureStringWidth "State: "                      pic
	  pic		    = EraseRectangle     ((x+width,y-10),(x+100,y+3))	pic
	  pic		    = MovePenTo		      (x+width+1,y)				    pic
	  pic		    = DrawString	      state						    pic
	  pic		    = SetPenColour	      BlackColour                   pic
	= pic
where
	(x,y)	= StatePos

DrawHeadRect :: !Int !Colour !Picture -> Picture
DrawHeadRect pos color pic
	# pic	= SetPenColour	color								pic
	  pic	= DrawRectangle	((pos,TapeY-11),(pos+11,TapeY+4))	pic
	  pic	= SetPenColour	BlackColour							pic
	= pic

HeadPos :: !Int -> Int
HeadPos pos = Offset+Room*pos-2

TransPos :: !Int -> (!Int,!Int)
TransPos nr = (Offset+140*(nr/14),TransY+15*(nr mod 14))

MoveToHeadPos :: !Int !Picture -> Picture
MoveToHeadPos pos pic = MovePenTo (pos+2,TapeY) pic

EraseCell :: !Int !Picture -> Picture
EraseCell x pic = EraseRectangle ((x+1,TapeY-10),(x+10,TapeY+3)) pic

DrawError :: !String !Picture -> Picture
DrawError mes pic
	# (width,pic)	= PictureStringWidth mes pic
	  pic			= DrawRectangle	((x-5,y-11),(x+width+5,y+4))	pic
	  pic			= SetPenColour	RedColour						pic
	  pic			= MovePenTo		(x,y)							pic
	  pic			= SetPenColour	BlackColour						pic
	  pic			= DrawString	mes								pic
	= pic
where
	(x,y)			= ErrorPos

EraseError :: !Picture -> Picture
EraseError pic
	= EraseRectangle ((ex-5,ey-11),(ex+299,ey+4)) pic
where
	(ex,ey)	= ErrorPos


/*	For the dialogs:
*/
FourCharString :: !String -> String
FourCharString str
	| size str>4	= str%(0,3)
	| otherwise		= str

FirstChar :: !String -> Char
FirstChar str
	| size str==0	= '#'
	| otherwise		= str.[0]


/*	ClickedIn... determines where the mouse clicked: on a tape cell,
	on a transition, on the state or on the name.
*/
ClickedInWindow :: !Point -> (!Int,!Bool,!Bool)
ClickedInWindow (x,y)
	| trans			= (trnr,True,False)
	| state			= (0, False, True )
	| otherwise		= (0, False, False)
where
	trans			= InRectangle (x,y) ((Offset,  TransY-13),(MaxX,     TransY+201))
	state			= InRectangle (x,y) ((statex-3,statey-10),(statex+79,statey+3  ))
	trnr			= (x-Offset)/120 * 14 + (y-(TransY-10))/15
	(statex,statey)	= StatePos

ClickedInTapeWd :: !Point -> (!Int,!Bool)
ClickedInTapeWd (x,y)
	| tape			= (tpos,True)
	| otherwise		= (0,False)
where
	tape			= InRectangle (x,y) ((Offset,TapeY-11),(MaxX,TapeY+4))
	tpos			= (x-Offset+3)/Room

InRectangle :: !Point !Rectangle -> Bool
InRectangle (x,y) ((lx,ly),(ux,uy)) = x>=lx && x<ux && y>ly && y<uy


/*	Functions to show a change of the T.M. when the T.M. is edited.
*/
HiliteTransition :: !Int !Transition !Picture -> Picture
HiliteTransition tnr transition pic
	# pic		= SetPenColour	YellowColour			pic
	  pic		= FillRectangle	((x,y-9),(x+131,y+2))	pic
	  pic		= SetPenColour	BlackColour				pic
	  pic		= DrawTrans		tnr transition			pic
	= pic
where
	(x,y)	= TransPos tnr
		   
HiliteState :: !String !Picture -> Picture
HiliteState state pic
	# pic	= SetPenColour	YellowColour			pic
	  pic	= FillRectangle	((x+39,y-9),(x+78,y+2))	pic
	  pic	= MovePenTo		(x+40,y)				pic
	  pic	= DrawString	state					pic
	  pic	= SetPenColour	BlackColour				pic
	= pic
where
	(x,y)	= StatePos

HiliteCell :: !Int !Char !Picture -> Picture
HiliteCell pos cell pic
	# pic	= EraseError									pic
	  pic	= SetPenColour	YellowColour					pic
	  pic	= FillRectangle	((x+1,TapeY-10),(x+10,TapeY+3))	pic
	  pic	= SetPenColour	BlackColour						pic
	  pic	= MovePenTo		(x+2,TapeY)						pic
	  pic	= DrawString	(toString cell)					pic
	= pic
where
	x		= HeadPos pos

ShowTrans :: !Int !Transition !Picture -> Picture
ShowTrans tnr transition pic
	# pic	= EraseTrans tnr pic
	  pic	= DrawTrans  tnr transition pic
	= pic

EraseTrans :: !Int !Picture -> Picture
EraseTrans tnr pic
	= EraseRectangle ((x,y-9),(x+131,y+2)) pic
where
	(x,y)	= TransPos tnr

DrawTapeCell :: !Int !Char !Picture -> Picture
DrawTapeCell pos cell pic
	# pic	= EraseCell		x				pic
	  pic	= MovePenTo		(x+2,TapeY)		pic
	  pic	= DrawString	(toString cell)	pic
	= pic
where
	x		= HeadPos pos

ShowHeadMove :: !Tape Int Int Int !Picture -> Picture
ShowHeadMove tape=:{head} end left right pic
	# pic = ShowTapePart tape left right				pic
	  pic	= DrawHeadRect (HeadPos head)	WhiteColour	pic
	  pic	= DrawHeadRect (HeadPos end)	RedColour	pic
	= pic

//	Set the font of the Turing machine windows.

SetTuringFont :: !Picture -> Picture
SetTuringFont pic
	= SetFontSize 10 (SetFontName "Courier" pic)
